module.exports = {
  apps: [{
    name: 'singleszone',
    script: './app.js',
    instances: 'max',
    exec_mode: 'cluster',
    env: {
      NODE_ENV: 'production',
      PORT: 3000
    },
    env_development: {
      NODE_ENV: 'development',
      PORT: 3000
    },
    error_file: './logs/err.log',
    out_file: './logs/out.log',
    log_file: './logs/combined.log',
    time: true,
    watch: false,
    max_memory_restart: '1G',
    
    // Auto-restart on crash
    autorestart: true,
    
    // Graceful shutdown
    kill_timeout: 5000,
    
    // Health monitoring
    max_restarts: 10,
    min_uptime: '10s'
  }]
};

// Additional configuration for monitoring
const monitoring = {
  name: 'singleszone-monitor',
  script: 'pm2-runtime',
  args: 'monit',
  env: {
    PM2_WEB_INTERFACE: true,
    PM2_API_PORT: 9615
  }
};