import React, { useState } from 'react';
import { Trophy, Award, Heart, Shield, Users, ArrowLeft, Gamepad2 } from 'lucide-react';
import { Button } from '../ui/button';
import { Tabs, TabsContent, TabsList, TabsTrigger } from '../ui/tabs';
import { useTranslation } from '../TranslationProvider';
import { MobileContestsPage } from './MobileContestsPage';
import MobileDatingCoachesPage from './MobileDatingCoachesPage';
import MobileDatingGamesPage from './MobileDatingGamesPage';
import { MobileHelpCenter } from './MobileHelpCenter';
import { MobileSafetyTips } from './MobileSafetyTips';
import { MobileCommunityGuidelines } from './MobileCommunityGuidelines';

interface MobileDiscoverPageProps {
  onNavigate: (view: string) => void;
  onOpenCookieConsent: () => void;
}

export function MobileDiscoverPage({ onNavigate, onOpenCookieConsent }: MobileDiscoverPageProps) {
  const { t } = useTranslation();
  const [activeTab, setActiveTab] = useState('contests');

  return (
    <div className="min-h-screen bg-gradient-to-br from-pink-50 via-purple-50 to-blue-50 dark:from-gray-900 dark:via-purple-900/20 dark:to-gray-900 pb-20">
      {/* Header */}
      <div className="bg-gradient-to-r from-purple-600 via-purple-700 to-purple-800 dark:from-purple-700 dark:via-purple-800 dark:to-purple-900 text-white sticky top-0 z-20">
        <div className="flex items-center justify-between p-4">
          <Button
            variant="ghost"
            size="sm"
            className="text-white p-2 -ml-2"
            onClick={() => onNavigate('search')}
          >
            <ArrowLeft className="h-5 w-5" />
          </Button>
          <div className="flex-1 text-center">
            <h1 className="text-xl">Discover & Learn</h1>
            <p className="text-xs text-purple-100">Safe dating experience</p>
          </div>
          <div className="w-9"></div>
        </div>
      </div>

      {/* Tabs */}
      <div className="sticky top-[73px] z-10 bg-white/95 dark:bg-gray-900/95 backdrop-blur-sm border-b dark:border-gray-800 overflow-x-auto">
        <Tabs value={activeTab} onValueChange={setActiveTab} className="w-full">
          <TabsList className="w-full grid grid-cols-6 bg-transparent h-auto p-0 rounded-none border-b-0">
            <TabsTrigger
              value="contests"
              className="flex flex-col items-center gap-1 py-3 px-1 data-[state=active]:bg-purple-50 dark:data-[state=active]:bg-purple-900/30 data-[state=active]:text-purple-600 dark:data-[state=active]:text-purple-400 border-b-2 border-transparent data-[state=active]:border-purple-600 dark:data-[state=active]:border-purple-400 rounded-none"
            >
              <Trophy className="w-4 h-4" />
              <span className="text-xs">Contests</span>
            </TabsTrigger>
            <TabsTrigger
              value="coaches"
              className="flex flex-col items-center gap-1 py-3 px-1 data-[state=active]:bg-purple-50 dark:data-[state=active]:bg-purple-900/30 data-[state=active]:text-purple-600 dark:data-[state=active]:text-purple-400 border-b-2 border-transparent data-[state=active]:border-purple-600 dark:data-[state=active]:border-purple-400 rounded-none"
            >
              <Award className="w-4 h-4" />
              <span className="text-xs">Coaches</span>
            </TabsTrigger>
            <TabsTrigger
              value="games"
              className="flex flex-col items-center gap-1 py-3 px-1 data-[state=active]:bg-purple-50 dark:data-[state=active]:bg-purple-900/30 data-[state=active]:text-purple-600 dark:data-[state=active]:text-purple-400 border-b-2 border-transparent data-[state=active]:border-purple-600 dark:data-[state=active]:border-purple-400 rounded-none"
            >
              <Gamepad2 className="w-4 h-4" />
              <span className="text-xs">Games</span>
            </TabsTrigger>
            <TabsTrigger
              value="help"
              className="flex flex-col items-center gap-1 py-3 px-1 data-[state=active]:bg-purple-50 dark:data-[state=active]:bg-purple-900/30 data-[state=active]:text-purple-600 dark:data-[state=active]:text-purple-400 border-b-2 border-transparent data-[state=active]:border-purple-600 dark:data-[state=active]:border-purple-400 rounded-none"
            >
              <Heart className="w-4 h-4" />
              <span className="text-xs">Help</span>
            </TabsTrigger>
            <TabsTrigger
              value="safety"
              className="flex flex-col items-center gap-1 py-3 px-1 data-[state=active]:bg-purple-50 dark:data-[state=active]:bg-purple-900/30 data-[state=active]:text-purple-600 dark:data-[state=active]:text-purple-400 border-b-2 border-transparent data-[state=active]:border-purple-600 dark:data-[state=active]:border-purple-400 rounded-none"
            >
              <Shield className="w-4 h-4" />
              <span className="text-xs">Safety</span>
            </TabsTrigger>
            <TabsTrigger
              value="community"
              className="flex flex-col items-center gap-1 py-3 px-1 data-[state=active]:bg-purple-50 dark:data-[state=active]:bg-purple-900/30 data-[state=active]:text-purple-600 dark:data-[state=active]:text-purple-400 border-b-2 border-transparent data-[state=active]:border-purple-600 dark:data-[state=active]:border-purple-400 rounded-none"
            >
              <Users className="w-4 h-4" />
              <span className="text-xs">Community</span>
            </TabsTrigger>
          </TabsList>

          {/* Tab Content */}
          <TabsContent value="contests" className="m-0">
            <MobileContestsPage onNavigate={onNavigate} />
          </TabsContent>

          <TabsContent value="coaches" className="m-0">
            <MobileDatingCoachesPage />
          </TabsContent>

          <TabsContent value="games" className="m-0">
            <MobileDatingGamesPage onNavigate={onNavigate} />
          </TabsContent>

          <TabsContent value="help" className="m-0">
            <MobileHelpCenter />
          </TabsContent>

          <TabsContent value="safety" className="m-0">
            <MobileSafetyTips />
          </TabsContent>

          <TabsContent value="community" className="m-0">
            <MobileCommunityGuidelines />
          </TabsContent>
        </Tabs>
      </div>
    </div>
  );
}

// Placeholder components for other tabs (these should already exist or can be created)
function MobileContestsPage({ onNavigate }: { onNavigate: (view: string) => void }) {
  return (
    <div className="p-4">
      <p className="text-center text-gray-600 dark:text-gray-400">Contests content (use existing ContestsPage component)</p>
    </div>
  );
}

function MobileHelpCenter() {
  return (
    <div className="p-4 space-y-4">
      <div className="text-center mb-6">
        <h2 className="text-xl font-semibold mb-2">How can we help you?</h2>
        <p className="text-sm text-gray-600 dark:text-gray-400">Find answers to common questions</p>
      </div>
      <p className="text-center text-gray-600 dark:text-gray-400">Help Center content</p>
    </div>
  );
}

function MobileSafetyTips() {
  return (
    <div className="p-4 space-y-4">
      <div className="text-center mb-6">
        <h2 className="text-xl font-semibold mb-2">Your Safety is Our Priority</h2>
        <p className="text-sm text-gray-600 dark:text-gray-400">Follow these guidelines for safe dating</p>
      </div>
      <p className="text-center text-gray-600 dark:text-gray-400">Safety Tips content</p>
    </div>
  );
}

function MobileCommunityGuidelines() {
  return (
    <div className="p-4 space-y-4">
      <div className="text-center mb-6">
        <h2 className="text-xl font-semibold mb-2">Community Guidelines</h2>
        <p className="text-sm text-gray-600 dark:text-gray-400">Help us maintain a respectful environment</p>
      </div>
      <p className="text-center text-gray-600 dark:text-gray-400">Community Guidelines content</p>
    </div>
  );
}
