import { Card, CardContent, CardHeader, CardTitle } from "./ui/card";
import { Button } from "./ui/button";
import { ArrowLeft, FileText, Users, Shield, AlertTriangle, Scale, Globe } from "lucide-react";

interface TermsPageProps {
  onBack: () => void;
}

export function TermsPage({ onBack }: TermsPageProps) {
  return (
    <div className="min-h-screen bg-background">
      <div className="max-w-4xl mx-auto p-6">
        <div className="mb-6">
          <Button 
            variant="ghost" 
            onClick={onBack}
            className="mb-4 flex items-center gap-2"
          >
            <ArrowLeft className="w-4 h-4" />
            Back to Home
          </Button>
          <h1 className="text-3xl font-bold text-foreground">Terms of Service</h1>
          <p className="text-muted-foreground mt-2">Last updated: January 2025</p>
        </div>

        <div className="space-y-6">
          <Card>
            <CardHeader>
              <CardTitle className="flex items-center gap-2">
                <FileText className="w-5 h-5 text-purple-600" />
                Agreement to Terms
              </CardTitle>
            </CardHeader>
            <CardContent>
              <p className="text-muted-foreground">
                By accessing and using Hotzonne, you agree to be bound by these Terms of Service and all applicable laws and regulations. 
                If you do not agree with any of these terms, you are prohibited from using or accessing this site.
              </p>
            </CardContent>
          </Card>

          <Card>
            <CardHeader>
              <CardTitle className="flex items-center gap-2">
                <Users className="w-5 h-5 text-blue-600" />
                Eligibility and Account Requirements
              </CardTitle>
            </CardHeader>
            <CardContent className="space-y-4">
              <div>
                <h4 className="font-semibold mb-2">Age Requirements</h4>
                <ul className="list-disc list-inside text-muted-foreground space-y-1">
                  <li>You must be at least 18 years old to use Hotzonne</li>
                  <li>You must provide accurate age verification</li>
                  <li>Misrepresenting your age is grounds for account termination</li>
                </ul>
              </div>
              <div>
                <h4 className="font-semibold mb-2">Account Responsibilities</h4>
                <ul className="list-disc list-inside text-muted-foreground space-y-1">
                  <li>Provide accurate and truthful information</li>
                  <li>Maintain the security of your account credentials</li>
                  <li>One account per person - multiple accounts prohibited</li>
                  <li>Notify us immediately of any unauthorized access</li>
                </ul>
              </div>
            </CardContent>
          </Card>

          <Card>
            <CardHeader>
              <CardTitle className="flex items-center gap-2">
                <Shield className="w-5 h-5 text-green-600" />
                Community Guidelines
              </CardTitle>
            </CardHeader>
            <CardContent className="space-y-4">
              <div>
                <h4 className="font-semibold mb-2">Acceptable Use</h4>
                <ul className="list-disc list-inside text-muted-foreground space-y-1">
                  <li>Be respectful and kind to other members</li>
                  <li>Use appropriate language and behavior</li>
                  <li>Upload genuine, recent photos of yourself</li>
                  <li>Engage in honest and authentic communication</li>
                </ul>
              </div>
              <div>
                <h4 className="font-semibold mb-2">Prohibited Activities</h4>
                <ul className="list-disc list-inside text-muted-foreground space-y-1">
                  <li>Harassment, bullying, or threatening behavior</li>
                  <li>Sharing explicit or inappropriate content</li>
                  <li>Spam, solicitation, or commercial activities</li>
                  <li>Impersonating others or creating fake profiles</li>
                  <li>Sharing personal contact information publicly</li>
                </ul>
              </div>
            </CardContent>
          </Card>

          <Card>
            <CardHeader>
              <CardTitle className="flex items-center gap-2">
                <AlertTriangle className="w-5 h-5 text-orange-600" />
                Content and Intellectual Property
              </CardTitle>
            </CardHeader>
            <CardContent className="space-y-4">
              <div>
                <h4 className="font-semibold mb-2">Your Content</h4>
                <p className="text-muted-foreground mb-2">
                  By uploading content to Hotzonne, you grant us a license to use, display, and distribute your content for platform operations.
                </p>
                <ul className="list-disc list-inside text-muted-foreground space-y-1">
                  <li>You retain ownership of your content</li>
                  <li>You must have rights to all content you upload</li>
                  <li>We may remove content that violates our guidelines</li>
                </ul>
              </div>
              <div>
                <h4 className="font-semibold mb-2">Platform Content</h4>
                <p className="text-muted-foreground">
                  All Hotzonne branding, features, and functionality are owned by us and protected by intellectual property laws.
                </p>
              </div>
            </CardContent>
          </Card>

          <Card>
            <CardHeader>
              <CardTitle className="flex items-center gap-2">
                <Scale className="w-5 h-5 text-red-600" />
                Limitation of Liability
              </CardTitle>
            </CardHeader>
            <CardContent>
              <p className="text-muted-foreground mb-4">
                Hotzonne is provided "as is" without warranties of any kind. We are not liable for:
              </p>
              <ul className="list-disc list-inside text-muted-foreground space-y-1">
                <li>Actions or conduct of other users</li>
                <li>Technical issues or service interruptions</li>
                <li>Loss of data or account information</li>
                <li>Indirect, incidental, or consequential damages</li>
                <li>Outcomes of relationships formed through the platform</li>
              </ul>
            </CardContent>
          </Card>

          <Card>
            <CardHeader>
              <CardTitle>Safety and Security</CardTitle>
            </CardHeader>
            <CardContent>
              <div className="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg p-4 mb-4">
                <div className="flex items-start gap-3">
                  <AlertTriangle className="w-5 h-5 text-yellow-600 mt-0.5" />
                  <div>
                    <h5 className="font-semibold text-yellow-800 dark:text-yellow-200">Safety Reminder</h5>
                    <p className="text-yellow-700 dark:text-yellow-300 text-sm mt-1">
                      Always meet in public places, tell friends about your plans, and trust your instincts when meeting someone new.
                    </p>
                  </div>
                </div>
              </div>
              <ul className="list-disc list-inside text-muted-foreground space-y-1">
                <li>Report suspicious or inappropriate behavior immediately</li>
                <li>Never share financial information or send money</li>
                <li>Use the platform's messaging system initially</li>
                <li>Block and report users who violate guidelines</li>
              </ul>
            </CardContent>
          </Card>

          <Card>
            <CardHeader>
              <CardTitle>Account Termination</CardTitle>
            </CardHeader>
            <CardContent>
              <p className="text-muted-foreground mb-4">
                We reserve the right to suspend or terminate accounts that violate these terms:
              </p>
              <ul className="list-disc list-inside text-muted-foreground space-y-1">
                <li>Violation of community guidelines</li>
                <li>Fraudulent or deceptive behavior</li>
                <li>Repeated user complaints</li>
                <li>Illegal activities</li>
                <li>Terms of service violations</li>
              </ul>
            </CardContent>
          </Card>

          <Card>
            <CardHeader>
              <CardTitle className="flex items-center gap-2">
                <Globe className="w-5 h-5 text-purple-600" />
                Contact Information
              </CardTitle>
            </CardHeader>
            <CardContent>
              <p className="text-muted-foreground mb-4">
                If you have questions about these Terms of Service, please contact us:
              </p>
              <div className="space-y-2 text-muted-foreground">
                <p>Email: legal@hotzonne.com</p>
                <p>Phone: +1 (555) 123-4567</p>
                <p>Address: 123 Love Street, Romance City</p>
              </div>
            </CardContent>
          </Card>

          {/* Bottom Navigation */}
          <div className="flex justify-center pt-8 border-t">
            <Button 
              onClick={onBack}
              size="lg"
              className="min-w-[200px]"
            >
              Back to Search
            </Button>
          </div>
        </div>
      </div>
    </div>
  );
}