import { useEffect } from 'react';
import { useUser } from './UserProvider';
import { toast } from 'sonner@2.0.3';

export function SubscriptionExpiryChecker() {
  const { user, checkSubscriptionExpiry } = useUser();

  useEffect(() => {
    // Check expiry immediately and then every hour
    const checkExpiry = () => {
      checkSubscriptionExpiry();
    };

    checkExpiry();
    const interval = setInterval(checkExpiry, 3600000); // Check every hour

    return () => clearInterval(interval);
  }, [checkSubscriptionExpiry]);

  useEffect(() => {
    // Show warning for expiring subscriptions (7 days before)
    if (user?.subscriptionOverride?.isActive && user.subscriptionOverride.expirationDate) {
      const expiryDate = new Date(user.subscriptionOverride.expirationDate);
      const now = new Date();
      const daysUntilExpiry = Math.ceil((expiryDate.getTime() - now.getTime()) / (1000 * 60 * 60 * 24));

      if (daysUntilExpiry <= 7 && daysUntilExpiry > 0) {
        toast.warning(`Your premium access expires in ${daysUntilExpiry} days`, {
          description: 'Contact support if you need to extend your access',
          duration: 10000,
        });
      }
    }
  }, [user]);

  return null; // This component doesn't render anything
}