import { useState } from "react";
import { Header } from "./Header";
import { Footer } from "./Footer";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "./ui/tabs";
import { Button } from "./ui/button";
import { 
  User, 
  Camera, 
  Shield, 
  Bell, 
  Lock,
  Video,
  CheckCircle,
  Palette
} from "lucide-react";
import { AccountTabWithVerification } from "./AccountTabWithVerification";
import { UsernameChangeRequest } from "./UsernameChangeRequest";
import { ColorThemeTab } from "./ColorThemeTab";
import { ProfileInfoTab } from "./ProfileInfoTab";
import { PhotoManagementTab } from "./PhotoManagementTab";
import { MediaSettingsTab } from "./MediaSettingsTab";
import { PrivacySettingsTab } from "./PrivacySettingsTab";
import { NotificationSettingsTab } from "./NotificationSettingsTab";

interface SimpleProfileSettingsPageProps {
  onNavigate: (view: string) => void;
  onOpenCookieConsent?: () => void;
}

export function SimpleProfileSettingsPage({ onNavigate, onOpenCookieConsent }: SimpleProfileSettingsPageProps) {
  const [activeTab, setActiveTab] = useState("profile");

  return (
    <div className="min-h-screen bg-background">
      <Header currentView="profile-settings" onNavigate={onNavigate} />
      
      <div className="max-w-6xl mx-auto px-6 py-8">
        <div className="mb-8">
          <h1 className="text-3xl font-bold mb-2">Profile Settings</h1>
          <p className="text-muted-foreground">
            Manage your profile information, privacy settings, and account preferences
          </p>
        </div>

        <Tabs value={activeTab} onValueChange={setActiveTab} className="space-y-6">
          <TabsList className="grid w-full grid-cols-2 sm:grid-cols-4 lg:grid-cols-8">
            <TabsTrigger value="profile" className="flex items-center gap-2">
              <User className="w-4 h-4" />
              <span className="hidden sm:inline">Profile</span>
            </TabsTrigger>
            <TabsTrigger value="username" className="flex items-center gap-2">
              <User className="w-4 h-4" />
              <span className="hidden sm:inline">Username</span>
            </TabsTrigger>
            <TabsTrigger value="photos" className="flex items-center gap-2">
              <Camera className="w-4 h-4" />
              <span className="hidden sm:inline">Photos</span>
            </TabsTrigger>
            <TabsTrigger value="colors" className="flex items-center gap-2">
              <Palette className="w-4 h-4" />
              <span className="hidden sm:inline">Colors</span>
            </TabsTrigger>
            <TabsTrigger value="media" className="flex items-center gap-2">
              <Video className="w-4 h-4" />
              <span className="hidden sm:inline">Media</span>
            </TabsTrigger>
            <TabsTrigger value="privacy" className="flex items-center gap-2">
              <Shield className="w-4 h-4" />
              <span className="hidden sm:inline">Privacy</span>
            </TabsTrigger>
            <TabsTrigger value="notifications" className="flex items-center gap-2">
              <Bell className="w-4 h-4" />
              <span className="hidden sm:inline">Notifications</span>
            </TabsTrigger>
            <TabsTrigger value="account" className="flex items-center gap-2">
              <Lock className="w-4 h-4" />
              <span className="hidden sm:inline">Account</span>
            </TabsTrigger>
          </TabsList>

          {/* Profile Tab */}
          <TabsContent value="profile">
            <ProfileInfoTab />
          </TabsContent>

          {/* Username Tab */}
          <TabsContent value="username">
            <UsernameChangeRequest />
          </TabsContent>

          {/* Photos Tab */}
          <TabsContent value="photos">
            <PhotoManagementTab />
          </TabsContent>

          {/* Colors Tab */}
          <TabsContent value="colors">
            <ColorThemeTab />
          </TabsContent>

          {/* Media Tab */}
          <TabsContent value="media">
            <MediaSettingsTab />
          </TabsContent>

          {/* Privacy Tab */}
          <TabsContent value="privacy">
            <PrivacySettingsTab />
          </TabsContent>

          {/* Notifications Tab */}
          <TabsContent value="notifications">
            <NotificationSettingsTab />
          </TabsContent>

          {/* Account Tab */}
          <TabsContent value="account">
            <AccountTabWithVerification onNavigate={onNavigate} />
          </TabsContent>
        </Tabs>
      </div>

      <Footer onNavigate={onNavigate} onOpenCookieConsent={onOpenCookieConsent} />
    </div>
  );
}