import { motion } from "motion/react";

export function SearchBanner() {
  return (
    <div className="bg-gradient-to-r from-purple-600 via-purple-700 to-purple-800 dark:from-purple-700 dark:via-purple-800 dark:to-purple-900 text-white py-11 relative overflow-hidden">
      {/* Moving gradient overlay */}
      <motion.div 
        className="absolute inset-0 bg-gradient-to-r from-transparent via-purple-300/30 to-transparent opacity-40"
        animate={{
          x: ['-100%', '100%']
        }}
        transition={{
          duration: 8,
          repeat: Infinity,
          ease: "linear",
          repeatDelay: 2
        }}
        style={{
          width: '200%',
          background: 'linear-gradient(90deg, transparent 0%, rgba(255,255,255,0.15) 25%, rgba(255,255,255,0.3) 50%, rgba(255,255,255,0.15) 75%, transparent 100%)'
        }}
      />
      
      {/* Additional gradient overlay for more intensity on the right */}
      <div className="absolute inset-0 bg-gradient-to-r from-transparent via-purple-600/20 to-purple-800/40 dark:from-transparent dark:via-purple-700/20 dark:to-purple-900/40"></div>
      <div className="max-w-7xl mx-auto px-6 text-center relative z-10">
        <motion.h1 
          className="text-4xl font-bold mb-4"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ 
            duration: 0.8,
            ease: "easeOut"
          }}
        >
          <motion.span
            animate={{ 
              scale: [1, 1.05, 1],
            }}
            transition={{
              duration: 3,
              repeat: Infinity,
              ease: "easeInOut",
              repeatDelay: 0.5
            }}
          >
            Find Your Connection
          </motion.span>
        </motion.h1>
        <motion.p 
          className="text-lg text-purple-100 dark:text-purple-200"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ 
            duration: 0.8,
            delay: 0.2,
            ease: "easeOut"
          }}
        >
          Use the filters below to discover new people.
        </motion.p>
      </div>
    </div>
  );
}