import { Button } from "./ui/button";
import { Card, CardContent, CardHeader, CardTitle } from "./ui/card";
import { Badge } from "./ui/badge";
import { useUser, useRoleSwitcher, UserRole } from "./UserProvider";
import { Settings, Crown, Shield, Users, User } from "lucide-react";

export function RoleSwitcher() {
  const { user } = useUser();
  const { switchToRole } = useRoleSwitcher();

  const roles: { role: UserRole; label: string; icon: any; color: string }[] = [
    { role: "super-admin", label: "Super Admin", icon: Crown, color: "purple" },
    { role: "admin", label: "Admin", icon: Shield, color: "blue" },
    { role: "moderator", label: "Moderator", icon: Settings, color: "green" },
    { role: "premium", label: "Premium User", icon: Users, color: "yellow" },
    { role: "user", label: "Free User", icon: User, color: "gray" }
  ];

  if (!user) return null;

  return (
    <Card className="fixed bottom-4 right-4 w-80 z-50 shadow-lg border-2">
      <CardHeader className="pb-2">
        <CardTitle className="text-sm flex items-center gap-2">
          <Settings className="w-4 h-4" />
          Role Switcher (Demo)
        </CardTitle>
      </CardHeader>
      <CardContent className="space-y-2">
        <div className="text-xs text-muted-foreground mb-2">
          Current: <Badge className="ml-1">{user.role}</Badge>
          <Badge className="ml-1" variant={user.membershipTier === "free" ? "secondary" : "default"}>
            {user.membershipTier}
          </Badge>
        </div>
        <div className="grid grid-cols-2 gap-1">
          {roles.map(({ role, label, icon: Icon, color }) => (
            <Button
              key={role}
              onClick={() => switchToRole(role)}
              variant={user.role === role ? "default" : "outline"}
              size="sm"
              className="text-xs p-2 h-auto"
            >
              <Icon className="w-3 h-3 mr-1" />
              {label}
            </Button>
          ))}
        </div>
      </CardContent>
    </Card>
  );
}