import { Button } from "./ui/button";
import {
  Select,
  SelectContent,
  SelectItem,
  SelectTrigger,
  SelectValue,
} from "./ui/select";
import { useTranslation, languageOptions } from "./TranslationProvider";
import { Globe } from "lucide-react";

interface LanguageSelectorProps {
  variant?: "full" | "compact" | "icon";
  className?: string;
}

export function LanguageSelector({ variant = "full", className = "" }: LanguageSelectorProps) {
  const { language, setLanguage, t } = useTranslation();

  const currentLanguage = languageOptions.find(option => option.value === language);

  if (variant === "icon") {
    return (
      <Select value={language} onValueChange={setLanguage}>
        <SelectTrigger className={`w-auto h-auto p-2 border-none bg-transparent hover:bg-accent ${className}`}>
          <Globe className="w-4 h-4" />
        </SelectTrigger>
        <SelectContent>
          {languageOptions.map((option) => (
            <SelectItem key={option.value} value={option.value}>
              <div className="flex items-center gap-2">
                <span>{option.flag}</span>
                <span>{option.label}</span>
              </div>
            </SelectItem>
          ))}
        </SelectContent>
      </Select>
    );
  }

  if (variant === "compact") {
    return (
      <Select value={language} onValueChange={setLanguage}>
        <SelectTrigger className={`w-auto ${className}`}>
          <div className="flex items-center gap-2">
            <span>{currentLanguage?.flag}</span>
            <span className="hidden sm:inline">{currentLanguage?.label}</span>
          </div>
        </SelectTrigger>
        <SelectContent>
          {languageOptions.map((option) => (
            <SelectItem key={option.value} value={option.value}>
              <div className="flex items-center gap-2">
                <span>{option.flag}</span>
                <span>{option.label}</span>
              </div>
            </SelectItem>
          ))}
        </SelectContent>
      </Select>
    );
  }

  return (
    <div className={`space-y-2 ${className}`}>
      <label className="text-sm font-medium">{t('auth.language')}</label>
      <Select value={language} onValueChange={setLanguage}>
        <SelectTrigger>
          <SelectValue>
            <div className="flex items-center gap-2">
              <span>{currentLanguage?.flag}</span>
              <span>{currentLanguage?.label}</span>
            </div>
          </SelectValue>
        </SelectTrigger>
        <SelectContent>
          {languageOptions.map((option) => (
            <SelectItem key={option.value} value={option.value}>
              <div className="flex items-center gap-2">
                <span>{option.flag}</span>
                <span>{option.label}</span>
              </div>
            </SelectItem>
          ))}
        </SelectContent>
      </Select>
    </div>
  );
}