import { GoogleMapsSetupInstructions } from './GoogleMapsConfig';
import { Header } from './Header';
import { Footer } from './Footer';
import { Button } from './ui/button';
import { ArrowLeft } from 'lucide-react';

interface GoogleMapsSetupPageProps {
  onNavigate: (view: string) => void;
  onBack?: () => void;
}

export function GoogleMapsSetupPage({ onNavigate, onBack }: GoogleMapsSetupPageProps) {
  return (
    <div className="min-h-screen bg-background">
      <Header currentView="setup" onNavigate={onNavigate} />
      
      <div className="container mx-auto py-8">
        <div className="mb-6">
          <Button
            variant="ghost"
            onClick={onBack || (() => onNavigate('search'))}
            className="flex items-center gap-2"
          >
            <ArrowLeft className="w-4 h-4" />
            Back
          </Button>
        </div>
        
        <GoogleMapsSetupInstructions />
      </div>
      
      <Footer onNavigate={onNavigate} />
    </div>
  );
}