import { isDevelopmentMode } from './GoogleMapsApiConfig';

interface GoogleMapsDevelopmentWrapperProps {
  children: React.ReactNode;
}

export function GoogleMapsDevelopmentWrapper({ children }: GoogleMapsDevelopmentWrapperProps) {
  // In development mode (no API key), we suppress all Google Maps errors
  // and let components show placeholders gracefully
  
  // Override console methods during development to suppress Google Maps warnings
  if (isDevelopmentMode()) {
    const originalWarn = console.warn;
    const originalError = console.error;
    
    console.warn = (...args) => {
      const message = args.join(' ');
      if (message.includes('Google Maps') || message.includes('maps.googleapis.com')) {
        // Suppress Google Maps related warnings
        return;
      }
      originalWarn.apply(console, args);
    };
    
    console.error = (...args) => {
      const message = args.join(' ');
      if (message.includes('Google Maps') || message.includes('maps.googleapis.com')) {
        // Suppress Google Maps related errors
        return;
      }
      originalError.apply(console, args);
    };
  }

  return <>{children}</>;
}