import { TabsContent } from "./ui/tabs";
import { AdminSupportTab } from "./AdminSupportTab";

interface AdminSupportTabContentProps {
  supportPages: {
    helpCenter: {
      title: string;
      lastUpdated: string;
      content: string;
      status: string;
    };
    safetyTips: {
      title: string;
      lastUpdated: string;
      content: string;
      status: string;
    };
    communityGuidelines: {
      title: string;
      lastUpdated: string;
      content: string;
      status: string;
    };
  };
  setSupportPages: React.Dispatch<React.SetStateAction<{
    helpCenter: {
      title: string;
      lastUpdated: string;
      content: string;
      status: string;
    };
    safetyTips: {
      title: string;
      lastUpdated: string;
      content: string;
      status: string;
    };
    communityGuidelines: {
      title: string;
      lastUpdated: string;
      content: string;
      status: string;
    };
  }>>;
  onNavigate: (view: string) => void;
}

export function AdminSupportTabContent({ supportPages, setSupportPages, onNavigate }: AdminSupportTabContentProps) {
  return (
    <TabsContent value="support">
      <AdminSupportTab 
        supportPages={supportPages}
        setSupportPages={setSupportPages}
        onNavigate={onNavigate}
      />
    </TabsContent>
  );
}